#!/bin/sh

BURN_INSTALL_CD=YES

if [ X$"BURN_INSTALL_CD"=XYES ]; then
    (cd `dirname $0`/subtree && \
     /usr/sbin/mkhybrid \
         -a -l -J -L -R -v \
         -b cdbr \
         -c boot.catalog \
         -A "OpenBSD 3.6" \
         -V `date +%Y-%m-%d` \
         -o ../OpenBSD-3.6.iso \
         .)
else
    /usr/sbin/mkhybrid \
        -a -l -J -L -R -T -v \
        "$@"
fi

exit

# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# NAME
#        mkhybrid	 - create an hybrid ISO9660/JOLIET/HFS filesystem
#        with optional Rock Ridge attributes.
# 
# SYNOPSIS
#        mkhybrid [ -a ] [ -abstract FILE ] [ -biblio FILE ]  [  -b
#        boot_image  ] [ -c boot_catalog ] [ -copyright FILE ] [ -A
#        application_id ] [ -f ] [ -d ] [ -D ] [	-hide  glob  ]	[
#        -hide-list  file	 ]  [ -hide-joliet glob ] [ -hide-joliet-
#        list file ] [ -J ] [ -l ] [ -L ] [ -log-file log_file ]	[
#        -no-split-symlink-components  ] [ -no-split-symlink-fields
#        ] [ -path-list file ] [ -p preparer ] [ -print-size ] [ -P
#        publisher  ] [ -quiet ] [ -r ] [ -R ] [ -sysid ID ] [ -T |
#        -table-name TABLE_NAME ] [ -v ] [ -V volid ] [ -volset  ID
#        ]  [ -volset-size # ] [ -volset-seqno # ] [ -x path ] [ -z
#        ] [ -m glob ] [ -hfs | -apple ] [ -map  mapping_file  ]	[
#        -magic  magic_file  ]  [ -no-mac-files ] [ -probe ] [ -no-
#        desktop ] [ -mac-name ]	[  -boot-hfs-file  driver_file	[
#        -part  ] [ -auto AutoStart_file ] [ -cluster-size size ] [
#        -hide-hfs glob ] [  -hide-hfs-list  file	 ]  [  -hfs-volid
#        hfs_volid  ]  [	-hfs-bless  folder_name	 ]  [  --cap  ] [
#        --netatalk ] [ --double ] [ --ethershare ] [ --ushare ]	[
#        --exchange ] [ --sgi ] [ --xinet ] [ --macbin ] [ --single
#        ] -o filename pathspec [pathspec]
# 
# DESCRIPTION
#        mkhybrid is effectively a pre-mastering program to  gener-
#        ate  an	HFS/ISO9660/JOLIET hybrid filesystem. It is based
#        on mkisofs(1) and will generate a pure ISO9660  filesystem
#        unless the HFS hybrid command line options are given.
# 
#        mkhybrid	 can  generate	a  true	 (or  shared)  HFS hybrid
#        filesystem. The same files are  seen  as	 HFS  files  when
#        accessed	 from  a  Macintosh  and  as  ISO9660  files when
#        accessed from other machines. HFS stands for  Hierarchical
#        File  System  and is the native file system used on Macin-
#        tosh computers.
# 
#        As an alternative, mkhybrid can generate the Apple  Enten-
#        sions  to  ISO9660 for each file. These extensions provide
#        each file with CREATOR, TYPE and certain Finder Flags when
#        accessed	 from a Macintosh. See the MACINTOSH FILE FORMATS
#        section below.
# 
#        mkhybrid takes a snapshot of a given directory  tree,  and
#        generates  a  binary  image  which  will	 correspond to an
#        ISO9660 or HFS filesystem when written to a block  device.
# 
#        mkhybrid	 is  also  capable  of	generating the System Use
#        Sharing Protocol	 records  specified  by	 the  Rock  Ridge
#        Interchange  Protocol.	This  is used to further describe
#        the files in the iso9660 filesystem to a	 unix  host,  and
#        provides	 information  such  as longer filenames, uid/gid,
#        posix permissions, and block and character devices.
# 
# Version 1.12b5.1	   7 April 1999				1
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        Each file written to the iso9660 filesystem  must  have	a
#        filename	 in the 8.3 format (8 characters, period, 3 char-
#        acters, all upper case), even if Rock  Ridge  is	 in  use.
#        This filename is used on systems that are not able to make
#        use of the Rock Ridge extensions	 (such	as  MS-DOS),  and
#        each filename in each directory must be different from the
#        other filenames in the same directory.  mkhybrid generally
#        tries  to  form correct names by forcing the unix filename
#        to upper case and truncating as required, but often  times
#        this  yields  unsatisfactory  results when there are cases
#        where the truncated names are not  all  unique.	 mkhybrid
#        assigns weightings to each filename, and if two names that
#        are otherwise the same are found the name with  the  lower
#        priority	 is renamed to have a 3 digit number as an exten-
#        sion (where the number is guaranteed to	be  unique).   An
#        example of this would be the files foo.bar and foo.bar.~1~
#        - the file foo.bar.~1~ would be written as  FOO.000;1  and
#        the file foo.bar would be written as FOO.BAR;1
# 
#        When  used  with the HFS options, mkhybrid will attempt to
#        recognise files stored in a number of Apple/Unix file for-
#        mats  and will copy the data and resource forks as well as
#        any relevant finder information. See  the  MACINTOSH  FILE
#        FORMATS section below for more about formats mkhybrid sup-
#        ports.
# 
#        Note that mkhybrid is not designed to communicate with the
#        writer  directly.   Most	 writers have proprietary command
#        sets which vary from one manufacturer to another, and  you
#        need  a	specialized  tool to actually burn the disk.  The
#        cdwrite utility is one such tool that runs under Linux and
#        performs	 this  task.   The  latest  version of cdwrite is
#        capable of communicating with Phillips/IMS/Kodak,  HP  and
#        Yamaha drives.  Most writers come with some version of DOS
#        software that allows a direct image  copy  of  an  iso9660
#        image  to  the  writer.	The current version of cdwrite is
#        available  from	 ftp://sunsite.unc.edu/utils/disk-manage-
#        ment/cdwrite-2.0.tar.gz	Note  that  cdwrite  has not been
#        actively maintained in recent times.
# 
#        The cdrecord utility is another utility capable of burning
#        an  actual disc.	 The latest version of cdrecord is avail-
#        able	from	 ftp://ftp.fokus.gmd.de/pub/unix/cdrecord
#        Cdrecord is under constant development.
# 
#        Also you should know that most cd writers are very partic-
#        ular about timing.  Once you start to  burn  a  disc,  you
#        cannot  let their buffer empty before you are done, or you
#        will end up with a corrupt disc.	 Thus it is critical that
#        you  be	able  to maintain an uninterrupted data stream to
#        the writer for the entire time  that  the  disc	is  being
#        written.
# 
#        pathspec	 is  the  path of the directory tree to be copied
# 
# Version 1.12b5.1	   7 April 1999				2
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        into the iso9660 filesystem.  Multiple paths can be speci-
#        fied,  and  mkhybrid  will merge the files found in all of
#        the specified path components to form the cdrom image.
# 
#        It is possible to graft the paths at points other than the
#        root  directory,	 and  it  is  possible	to graft files or
#        directories onto the cdrom image with names different than
#        what  they have in the source filesystem.  This is easiest
#        to illustrate with a couple of examples.	  Let's start  by
#        assuming that a local file ../old.lis exists, and you wish
#        to include it in the cdrom image.
# 
# 	    foo/bar/=../old.lis
# 
#        will include the	 file  old.lis	in  the	 cdrom	image  at
#        /foo/bar/old.lis, while
# 
# 	    foo/bar/xxx=../old.lis
# 
#        will  include  the  file	 old.lis  in  the  cdrom image at
#        /foo/bar/xxx.  The same sort of syntax can  be  used  with
#        directories as well.  mkhybrid will create any directories
#        required such that the graft points  exist  on  the  cdrom
#        image  -	 the  directories do not need to appear in one of
#        the paths.  Any directories that are created  on	 the  fly
#        like  this  will	 have  permissions  0555 and appear to be
#        owned by the person running mkhybrid.  If you  wish  other
#        permissions or owners of the intermediate directories, the
#        easiest solution is to create real directories in the path
#        such that mkhybrid doesn't have to invent them.
# 
#        mkhybrid will also run on Win9X/NT4 machines when compiled
#        with  Cygnus'  cygwin   (available   from   http://source-
#        ware.cygnus.com/cygwin/).  Therefore  most  references  in
#        this man page to Unix can be replaced with Win32.
# 
# OPTIONS
#        -a     Include all files on the iso9660 filesystem.   Nor-
# 	      mally  files that contain the characters '~' or '#'
# 	      will not be included (these  are	typically  backup
# 	      files for editors under unix).
# 
#        -abstract FILE
# 	      Specifies	 the  abstract file name.  This parameter
# 	      can  also	 be  set  in  the  file	 .mkisofsrc  with
# 	      ABST=filename.   If  specified  in both places, the
# 	      command line version is used.
# 
#        -A application_id
# 	      Specifies a text string that will be  written  into
# 	      the volume header.  This should describe the appli-
# 	      cation that will be on the disc.	There is space on
# 
# Version 1.12b5.1	   7 April 1999				3
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      the  disc	 for 128 characters of information.  This
# 	      parameter can also be set in  the	 file  .mkisofsrc
# 	      with  APPI=id.   If  specified  in both places, the
# 	      command line version is used.
# 
#        -biblio FILE
# 	      Specifies the bibliographic file name.  This param-
# 	      eter  can	 also  be set in the file .mkisofsrc with
# 	      BIBLO=filename.  If specified in both  places,  the
# 	      command line version is used.
# 
#        -b boot_image
# 	      Specifies	 the  path and filename of the boot image
# 	      to be used when making an "El Torito" bootable  CD.
# 	      The  pathname  must  be relative to the source path
# 	      specified to mkhybrid.  This option is required  to
# 	      make a bootable CD.  The boot image must be exactly
# 	      the size of one of a 1.2, 1.44, or 2.88 MB  floppy,
# 	      or  of a 2 KB CD sector, and mkhybrid will use this
# 	      size when creating the output  iso9660  filesystem.
# 	      If  the boot file is 2 KB long, a no-emulation boot
# 	      CD will be created, and the whole 2 KB will be read
# 	      on  boot.	 If the boot file is a floppy image, then
# 	      only the first 512-byte sector will  be  read  from
# 	      the  boot	 image	(it  is emulating a normal floppy
# 	      drive).  This will work, for example, if	the  boot
# 	      image is a LILO-based boot floppy.
# 
#        -C last_sess_start,next_sess_start
# 	      This  option is needed when mkisofs is used to cre-
# 	      ate the image of a second session or a higher level
# 	      session  for  a  multi session disk.  The option -C
# 	      takes a pair of two numbers separated by	a  comma.
# 	      The  first number is the sector number of the first
# 	      sector in the last session of the disk that  should
# 	      be  appended to.	The second number is the starting
# 	      sector number of the  new	 session.   The	 expected
# 	      pair   of	 numbers  may  be  retrieved  by  calling
# 	      cdrecord -msinfo ...  the -C  option  may	 only  be
# 	      uses in conjunction with the -M option.
# 
#        -c boot_catalog
# 	      Specifies the path and filename of the boot catalog
# 	      to be used when making an "El Torito" bootable  CD.
# 	      The  pathname  must  be relative to the source path
# 	      specified to mkhybrid.  This option is required  to
# 	      make  a  bootable CD.  This file will be created by
# 	      mkhybrid in the source filesystem, so be	sure  the
# 	      specified filename does not conflict with an exist-
# 	      ing file, as it will be quietly  overwritten!  Usu-
# 	      ally a name like "boot.catalog" is chosen.
# 
#        -copyright FILE
# 	      Specifies	 the Copyright file name.  This parameter
# 
# Version 1.12b5.1	   7 April 1999				4
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      can  also	 be  set  in  the  file	 .mkisofsrc  with
# 	      COPY=filename.   If  specified  in both places, the
# 	      command line version is used.
# 
#        -d     Omit trailing period from files that do not have	a
# 	      period.  This violates the ISO9660 standard, but it
# 	      happens to work on many systems.	Use with caution.
# 
#        -D     Do  not  use deep directory relocation, and instead
# 	      just pack them in the way we see them.   This  vio-
# 	      lates  the  ISO9660  standard, but it works on many
# 	      systems.	Use with caution.
# 
#        -f     Follow symbolic links when generating the	 filesys-
# 	      tem.   When  this	 option	 is  not in use, symbolic
# 	      links will be entered using Rock Ridge if	 enabled,
# 	      otherwise the file will be ignored.
# 
#        -hide glob
# 	      Hide  glob  from	being seen on the ISO9660 or Rock
# 	      Ridge directory.	glob is a  shell  wild-card-style
# 	      pattern that must match any part of the filename or
# 	      path.  Multiple globs may be hidden (up  to  1000).
# 	      If  glob	matches a directory, then the contents of
# 	      that directory will  be  hidden.	 All  the  hidden
# 	      files  will still be written to the output CD image
# 	      file.  Should be used with the -hide-joliet option.
# 
#        -hide-list file
# 	      A	 file  containing a list of globs to be hidden as
# 	      above.
# 
#        -hide-joliet glob
# 	      Hide glob from being seen on the Joliet  directory.
# 	      glob  is	a shell wild-card-style pattern that must
# 	      match any part of the filename or	 path.	 Multiple
# 	      globs  may be hidden (up to 1000).  If glob matches
# 	      a directory, then the contents  of  that	directory
# 	      will be hidden.  All the hidden files will still be
# 	      written to the output CD	image  file.   Should  be
# 	      used with the -hide option.
# 
#        -hide-joliet-list file
# 	      A	 file  containing a list of globs to be hidden as
# 	      above.
# 
#        -l     Allow full 32 character  filenames.   Normally  the
# 	      ISO9660  filename will be in an 8.3 format which is
# 	      compatible with MS-DOS,  even  though  the  ISO9660
# 	      standard	allows	filenames of up to 32 characters.
# 	      If you use this option, the disc may  be	difficult
# 	      to  use on a MS-DOS system, but this comes in handy
# 	      on some other systems (such  as  the  Amiga).   Use
# 	      with caution.
# 
# Version 1.12b5.1	   7 April 1999				5
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        -J     Generate	Joliet	directory  records in addition to
# 	      regular iso9660 file names.  This is primarily use-
# 	      ful  when the discs are to be used on Windows-NT or
# 	      Windows-95 machines.    The  Joliet  filenames  are
# 	      specified in Unicode and each path component can be
# 	      up to 64 Unicode characters long.
# 
#        -L     Allow filenames to begin with a period.  Usually, a
# 	      leading dot is replaced with an underscore in order
# 	      to maintain MS-DOS compatibility.
# 
#        -log-file log_file
# 	      Redirect all error, warning and informational  mes-
# 	      sages to log_file instead of the standard error.
# 
#        -m glob
# 	      Exclude  glob from being written to CDROM.  glob is
# 	      a shell wild-card-style  pattern	that  must  match
# 	      part  of	the filename (not the path as with option
# 	      -x).   Technically  glob	is  matched  against  the
# 	      d->d_name	 part  of  the directory entry.	 Multiple
# 	      globs may be excluded (up to 1000).  Example:
# 
# 	      mkhybrid -o rom -m '*.o' -m core -m foobar
# 
# 	      would exclude all	 files	ending	in  ".o",  called
# 	      "core" or "foobar" to be copied to CDROM. Note that
# 	      if you had a directory called "foobar" it too  (and
# 	      of course all its descendants) would be excluded.
# 
# 	      NOTE:  The -m and -x option description should both
# 	      be updated, they are wrong.  Both now work  identi-
# 	      cal and use filename globbing. A file is exluded if
# 	      either the last component matches or the whole path
# 	      matches.
# 
#        -exclude-list file
# 	      A	 file containing a list of globs to be exclude as
# 	      above.
# 
#        -M path
# 	      or
# 
#        -M device
# 	      Specifies path to	 existing  iso9660  image  to  be
# 	      merged.  The  alternate  form  takes  a SCSI device
# 	      specifier that uses the same  syntax  as	the  dev=
# 	      parameter of cdrecord.  The output of mkhybrid will
# 	      be a new session which should get	 written  to  the
# 	      end  of  the image specified in -M.  Typically this
# 	      requires multi-session capability for the	 recorder
# 	      and  cdrom  drive	 that you are attempting to write
# 	      this image to.  This option may  only  be	 used  in
# 	      conjunction with the -C option.
# 
# Version 1.12b5.1	   7 April 1999				6
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        -N     Omit version numbers from ISO9660 file names.  This
# 	      may violate the ISO9660 standard, but no one really
# 	      uses the version numbers anyway.	Use with caution.
# 
#        -no-split-symlink-components
# 	      Don't split the SL components, but begin a new Con-
# 	      tinuation	 Area  (CE)  instead. This may waste some
# 	      space, but the SunOS 4.1.4 cdrom driver has  a  bug
# 	      in  reading split SL components (link_size = compo-
# 	      nent_size instead of link_size +=	 component_size).
# 
#        -no-split-symlink-fields
# 	      Don't split the SL fields, but begin a new Continu-
# 	      ation Area (CE) instead. This may waste some space,
# 	      but  the SunOS 4.1.4 and Solaris 2.5.1 cdrom driver
# 	      have a bug in reading split SL fields (a `/' can be
# 	      dropped).
# 
#        -o filename
# 	      is  the  name  of	 the  file  to	which the iso9660
# 	      filesystem image should be written.  This can be	a
# 	      disk  file,  a  tape  drive,  or	it can correspond
# 	      directly to the device name  of  the  optical  disc
# 	      writer.	If  not	 specified, stdout is used.  Note
# 	      that the output can also be a block special  device
# 	      for  a  regular  disk drive, in which case the disk
# 	      partition can be mounted	and  examined  to  ensure
# 	      that the premastering was done correctly.
# 
#        -path-list file
# 	      A	 file  containing  a list of filespec directories
# 	      and filenames to be added to the	ISO9660	 filesys-
# 	      tem. This list of filespecs are processed after any
# 	      that appear on the command line. If the argument is
# 	      -, then the list is read from the standard input.
# 
#        -P publisher_id
# 	      Specifies	 a  text string that will be written into
# 	      the volume header.  This should describe	the  pub-
# 	      lisher of the CDROM, usually with a mailing address
# 	      and phone number.	 There is space on the	disc  for
# 	      128  characters of information.  This parameter can
# 	      also be set in the file .mkisofsrc with PUBL=.   If
# 	      specified	 in both places, the command line version
# 	      is used.
# 
#        -p preparer_id
# 	      Specifies a text string that will be  written  into
# 	      the  volume  header.  This should describe the pre-
# 	      parer of the CDROM, usually with a mailing  address
# 	      and  phone  number.  There is space on the disc for
# 	      128 characters of information.  This parameter  can
# 	      also  be set in the file .mkisofsrc with PREP=.  If
# 	      specified in both places, the command line  version
# 
# Version 1.12b5.1	   7 April 1999				7
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      is used.
# 
#        -print-size
# 	      Print  estimated	filesystem  size  and  exit. This
# 	      option is needed for Disk At  Once  mode	and  with
# 	      some   CD-R   drives   when  piping  directly  into
# 	      cdrecord.	 In this case it is needed  to	know  the
# 	      size  of	the  filesystem before the actual CD-cre-
# 	      ation is done.  The option  -print-size  allows  to
# 	      get  this	 size  from  a "dry-run" before the CD is
# 	      actually written.
# 
#        -quiet This makes mkhybrid even less verbose.  No progress
# 	      output will be provided.
# 
#        -R     Generate	SUSP  and RR records using the Rock Ridge
# 	      protocol to  further  describe  the  files  on  the
# 	      iso9660 filesystem.
# 
#        -r     This  is like the -R option, but file ownership and
# 	      modes are set to more useful values.  The	 uid  and
# 	      gid  are set to zero, because they are usually only
# 	      useful on the author's system, and  not  useful  to
# 	      the  client.   All the file read bits are set true,
# 	      so that files and directories are globally readable
# 	      on  the  client.	 If  any execute bit is set for a
# 	      file, set all of the execute bits, so that executa-
# 	      bles are globally executable on the client.  If any
# 	      search bit is set for a directory, set all  of  the
# 	      search  bits,  so	 that  directories  are	 globally
# 	      searchable on  the  client.   All	 write	bits  are
# 	      cleared,	because	 the CD-Rom will be mounted read-
# 	      only in any case.	 If any of the special mode  bits
# 	      are  set,	 clear	them,  because file locks are not
# 	      useful on a read-only file system, and set-id  bits
# 	      are not desirable for uid 0 or gid 0.  When used on
# 	      Win32, the execute bit is set on all files.
# 
#        -sysid ID
# 	      Specifies the system ID.	This parameter	can  also
# 	      be  set in the file .mkisofsrc with SYSI=system_id.
# 	      If specified in both places, the command line  ver-
# 	      sion is used.
# 
#        -T     Generate	a file TRANS.TBL in each directory on the
# 	      CDROM, which can be used on non-Rock Ridge  capable
# 	      systems  to  help establish the correct file names.
# 	      There is also information present in the file  that
# 	      indicates the major and minor numbers for block and
# 	      character devices, and each symlink has the name of
# 	      the link file given.
# 
#        -table-name TABLE_NAME
# 	      Alternative   translation	  table	 file  name  (see
# 
# Version 1.12b5.1	   7 April 1999				8
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      above). Implies the -T option.
# 
#        -V volid
# 	      Specifies the volume ID (volume name or  label)  to
# 	      be  written  into the master block.  This parameter
# 	      can  also	 be  set  in  the  file	 .mkisofsrc  with
# 	      VOLI=id.	 If specified in both places, the command
# 	      line version is used.  Note that if  you	assign	a
# 	      volume  ID,  this	 is the name that will be used as
# 	      the mount point used by the Solaris volume  manage-
# 	      ment  system  and	 the name that is assigned to the
# 	      disc on a Windows or Mac platform.
# 
#        -volset ID
# 	      Specifies the volset ID.	This parameter	can  also
# 	      be  set in the file .mkisofsrc with VOLS=volset_id.
# 	      If specified in both places, the command line  ver-
# 	      sion is used.
# 
#        -volset-size #
# 	      Sets the volume set size to #.  The volume set size
# 	      is the number of CD's that are in a  CD  set.   The
# 	      -volset-size option may be used to create CD's that
# 	      are part of e.g. a  Operation  System  installation
# 	      set of CD's.  The option -volset-size must be spec-
# 	      ified before -volset-seqno on each command line.
# 
#        -volset-seqno #
# 	      Sets the volume set sequence number to #.	 The vol-
# 	      ume  set sequence number is the index number of the
# 	      current CD in a CD set.	The  option  -volset-size
# 	      must be specified before -volset-seqno on each com-
# 	      mand line.
# 
#        -v     Verbose execution. If given twice	 on  the  command
# 	      line, extra debug information will be printed.
# 
#        -x path
# 	      Exclude  path  from  being  written to CDROM.  path
# 	      must be the complete  pathname  that  results  from
# 	      concatenating  the  pathname  given as command line
# 	      argument and the path relative to	 this  directory.
# 	      Multiple paths may be excluded (up to 1000).  Exam-
# 	      ple:
# 
# 	      mkhybrid -o cd -x /local/dir1 -x /local/dir2 /local
# 
# 	      NOTE:  The -m and -x option description should both
# 	      be updated, they are wrong.  Both now work  identi-
# 	      cal and use filename globbing. A file is exluded if
# 	      either the last component matches or the whole path
# 	      matches.
# 
#        -z     Generate	special	 SUSP  records	for transparently
# 
# Version 1.12b5.1	   7 April 1999				9
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      compressed files.	 This is only of use and interest
# 	      for  hosts  that support transparent decompression.
# 	      This is an experimental feature, and no  hosts  yet
# 	      support this, but there are ALPHA patches for Linux
# 	      that can make use of this feature.
# 
# HFS OPTIONS
#        -hfs   Create an ISO9660/HFS hybrid CD.	By  default,  all
# 	      source  files  are  checked to attempt to recognise
# 	      files stored in one of the  known	 Apple/Unix  file
# 	      formats.	 See  the  MACINTOSH FILE FORMATS section
# 	      below for more about these formats
# 
#        -apple Create an ISO9660 CD with Apple's extensions. Simi-
# 	      lar  to  the  -hfs  option,  except  that the Apple
# 	      Extensions to ISO9660 are added instead of creating
# 	      an HFS hybrid volume.
# 
#        -map mapping_file
# 	      Use  the	mapping_file  to set the CREATOR and TYPE
# 	      information for a	 file  based  on  the  filename's
# 	      extension.  A  filename is mapped only if it is not
# 	      one of the know Apple/Unix file  formats.	 See  the
# 	      CREATOR/TYPE section below.
# 
#        -magic magic_file
# 	      The  CREATOR and TYPE information is set by using a
# 	      file's magic number (usually the first few bytes of
# 	      a	 file).	 The magic_file is only used if a file is
# 	      not one of the known Apple/Unix  file  formats,  or
# 	      the  filename  extension	has not been mapped using
# 	      the -map option. See the CREATOR/TYPE section below
# 	      for more details.
# 
#        -no-mac-files
# 	      Disables	searching for Apple/Unix files. This will
# 	      speed up processing if there are none of the  known
# 	      Apple/Unix  format  files	 in  the source directory
# 	      trees (the source directories just contain ordinary
# 	      files).  The  -map and/or -magic option can be used
# 	      to set the CREATOR and TYPE for each file.
# 
#        -probe Search the contents of files  for	 Apple/Unix  file
# 	      formats. When -hfs or -apple is used, mkhybrid will
# 	      attempt to work  out  automatically  what	 type  of
# 	      Apple/Unix  format  each file is. However, the only
# 	      way to check for MacBinary and AppleSingle files is
# 	      to  open	and read them. Therefore, if MacBinary or
# 	      AppleSingle format files are being used,	then  you
# 	      need  to	give this option.  This saves opening and
# 	      searching	 every	file  if  no   MacBinary   and/or
# 	      AppleSingle files exist. Or you could use the rele-
# 	      vant double dash options given below.
# 
# Version 1.12b5.1	   7 April 1999			       10
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        -no-desktop
# 	      Do not create (empty) Desktop files. New HFS  Desk-
# 	      top  files will be created when the CD is used on a
# 	      Macintosh (and stored in the  System  Folder).   By
# 	      default,	empty  Desktop files are added to the HFS
# 	      volume.
# 
#        -mac-name
# 	      Use the HFS filename as the starting point for  the
# 	      ISO9660,	Joliet and Rock Ridge file names. See the
# 	      MACINTOSH FILE NAMES section below for more  infor-
# 	      mation.
# 
#        -boot-hfs-file driver_file
# 	      Installs	the  driver_file  that	may  make  the CD
# 	      bootable on a Macintosh. See the	HFS  BOOT  DRIVER
# 	      section below. (Alpha).
# 
#        -part  Generate	an  HFS	 partition  table. By default, no
# 	      partition table is generated, but some older Macin-
# 	      tosh  CDROM  drivers need an HFS partition table on
# 	      the CDROM to be able to recognize a hybrid CDROM.
# 
#        -auto AutoStart_file
# 	      Make the HFS CD use  the	QuickTime  2.0	Autostart
# 	      feature  to  launch an application or document. The
# 	      given filename must be the name of  a  document  or
# 	      application located at the top level of the CD. The
# 	      filename must be less than 12 characters.	 (Alpha).
# 
#        -cluster-size size
# 	      Set  the size in bytes of the cluster or allocation
# 	      units of PC Exchange files. See the MACINTOSH  FILE
# 	      FORMATS section below.
# 
#        -hide-hfs glob
# 	      Hide  glob  from the HFS volume. The file or direc-
# 	      tory will still exist in the ISO9660 and/or  Joliet
# 	      directory.  glob is a shell wild-card-style pattern
# 	      that must match any part of the  filename	 Multiple
# 	      globs may be excluded (up to 1000).  Example:
# 
# 	      mkhybrid -o rom -hfs -hide-hfs '*.o' -hide-hfs foo-
# 	      bar
# 
# 	      would exclude all files ending in	 ".o"  or  called
# 	      "foobar"	from the HFS volume. Note that if you had
# 	      a directory called "foobar" it too (and  of  course
# 	      all  its	descendants) would be excluded.	 The glob
# 	      can also be a path  name	relative  to  the  source
# 	      directories given on the command line. Example:
# 
# 	      mkhybrid -o rom -hfs -hide-hfs src/html src
# 
# Version 1.12b5.1	   7 April 1999			       11
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      would  exclude  just  the	 file or directory called
# 	      "html" from the "src" directory. Any other file  or
# 	      directory	 called	 "html"	 in  the tree will not be
# 	      excluded.	 Should be used	 with  the  -hide  and/or
# 	      -hide-joliet options.
# 
#        -hide-hfs-list file
# 	      A	 file  containing a list of globs to be hidden as
# 	      above.
# 
#        -hfs-volid hfs_volid
# 	      Volume name for the HFS partition. This is the name
# 	      that  is	assigned  to  the disc on a Macintosh and
# 	      replaces the volid used with the -V option
# 
#        -hfs-bless folder_name
# 	      "Bless" the given directory (folder). This is  usu-
# 	      ally  the System Folder and is used in creating HFS
# 	      bootable CDs. The name of the directory must be the
# 	      whole  path  name	 as  mkisofs sees it. e.g. if the
# 	      given pathspec is ./cddata and the required  folder
# 	      is  called  System Folder, then the whole path name
# 	      is "./cddata/System Folder" (remember to use quotes
# 	      if the name contains spaces).
# 
#        --cap  Look  for	 AUFS CAP Macintosh files. Search for CAP
# 	      Apple/Unix file formats  only.  Searching	 for  the
# 	      other possible Apple/Unix file formats is disabled,
# 	      unless other double dash options are given.
# 
#        --netatalk
# 	      Look for NETATALK Macintosh files
# 
#        --double
# 	      Look for AppleDouble Macintosh files
# 
#        --ethershare
# 	      Look for Helios EtherShare Macintosh files
# 
#        --ushare
# 	      Look for IPT UShare Macintosh files
# 
#        --exchange
# 	      Look for PC Exchange Macintosh files
# 
#        --sgi  Look for SGI Macintosh files
# 
#        --xinet
# 	      Look for XINET Macintosh files
# 
#        --macbin
# 	      Look for MacBinary Macintosh files
# 
# Version 1.12b5.1	   7 April 1999			       12
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        --single
# 	      Look for AppleSingle Macintosh files
# 
# CREATOR/TYPE
#        A Macintosh file has two	 properties  associated	 with  it
#        which  define which application created the file, the CRE-
#        ATOR and what data the file contains, the TYPE.	Both  are
#        (exactly)  4  letter strings. Usually this allows a Macin-
#        tosh user to double-click on a file and launch the correct
#        application etc. The CREATOR and TYPE of a particular file
#        can be found by using something like ResEdit (or	 similar)
#        on a Macintosh.
# 
#        The CREATOR and TYPE information is stored in all the var-
#        ious Apple/Unix encoded files.  For other files it is pos-
#        sible  to  base	the  CREATOR  and  TYPE on the filename's
#        extension using a mapping file (the  -map  option)  and/or
#        using  the  magic number (usually a signature in the first
#        few bytes) of a file (the -magic option).  If  both  these
#        options are given, then their order on the command line is
#        important. If the -map option is given first, then a file-
#        name  extension	match  is attempted before a magic number
#        match. However, if the -magic option is given first,  then
#        a magic number match is attempted before a filename exten-
#        sion match.
# 
#        If a mapping or magic file is not used,	or  no	match  is
#        found  then  the	 default CREATOR and TYPE for all regular
#        files can be set by using entries in the .mkisofsrc  file,
#        otherwise  the  default	CREATOR	 and  TYPE are 'unix' and
#        'TEXT'.
# 
#        The format of the mapping file is the same afpfile  format
#        as  used	 by  aufs.   This  file	 has five columns for the
#        extension, file translation, CREATOR,  TYPE  and	 Comment.
#        Lines  starting	with  the '#' character are comment lines
#        and are ignored. An example file would be like:
# 
#        # Example filename mapping file
#        #
#        # EXTN	XLate	CREATOR	  TYPE	   Comment
#        .tif	Raw	'8BIM'	  'TIFF'   "Photoshop TIFF image"
#        .hqx	Ascii	'BnHq'	  'TEXT'   "BinHex file"
#        .doc	Raw	'MSWD'	  'WDBN'   "Word file"
#        .mov	Raw	'TVOD'	  'MooV'   "QuickTime Movie"
#        *	Ascii	'ttxt'	  'TEXT'   "Text file"
# 
#        Where:
# 
# 	      The first column EXTN  defines  the  Unix	 filename
# 	      extension to be mapped. The default mapping for any
# 	      filename extension that doesn't  match  is  defined
# 
# Version 1.12b5.1	   7 April 1999			       13
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      with the "*" character.
# 
# 	      The  Xlate column defines the type of text transla-
# 	      tion between the Unix  and  Macintosh  file  it  is
# 	      ignored  by  mkhybrid, but is kept to be compatible
# 	      with aufs(1).  Although mkhybrid does not alter the
# 	      contents	of a file, if a binary file has it's TYPE
# 	      set as 'TEXT', it may be read incorrectly on a Mac-
# 	      intosh.  Therefore  a better choice for the default
# 	      TYPE may be '????'
# 
# 	      The CREATOR and TYPE keywords must be 4  characters
# 	      long and enclosed in single quotes.
# 
# 	      The comment field is enclosed in double quotes - it
# 	      is ignored by mkhybrid, but is kept to be	 compati-
# 	      ble with aufs.
# 
#        The  format  of	the magic file is almost identical to the
#        magic(4) file used by the Linux file(1) command - the rou-
#        tines for reading and decoding the magic file are based on
#        the Linux file(1) command.
# 
#        This file has four tab separated columns for the byte off-
#        set,  type, test and message.  Lines starting with the '#'
#        character are comment lines and are  ignored.  An  example
#        file would be like:
# 
#        # Example magic file
#        #
#        # off   type	 test	    message
#        0       string	 GIF8	    8BIM GIFf  GIF image
#        0       beshort	 0xffd8	    8BIM JPEG  image data
#        0       string	 SIT!	    SIT! SIT!  StuffIt Archive
#        0       string	 \037\235   LZIV ZIVU  standard unix compress
#        0       string	 \037\213   GNUz ZIVU  gzip compressed data
#        0       string	 %!	    ASPS TEXT  Postscript
#        0       string	 \004%!	    ASPS TEXT  PC Postscript with a ^D to start
#        4       string	 moov	    txtt MooV  QuickTime movie file (moov)
#        4       string	 mdat	    txtt MooV  QuickTime movie file (mdat)
# 
#        The  format  of	the file is described in the magic(4) man
#        page. The only difference here is that for each	entry  in
#        the magic file, the message for the initial offset must be
#        4 characters for the CREATOR followed by 4 characters  for
#        the TYPE - white space is optional between them. Any other
#        characters on this line are ignored.   Continuation  lines
#        (starting  with a '>') are also ignored i.e. only the ini-
#        tial offset lines are used.
# 
#        Using the -magic option may  significantly  increase  pro-
#        cessing	time  as each file has to opened and read to find
#        it's magic number.
# 
# Version 1.12b5.1	   7 April 1999			       14
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        In summary, for all files, the default CREATOR  is  'unix'
#        and  the	 default TYPE is 'TEXT'.  These can be changed by
#        using entries in the .mkisofsrc file.
# 
#        If the a file is in one of the  known  Apple/Unix  formats
#        (and  the  format has been selected), then the CREATOR and
#        TYPE are taken from the values stored  in  the  Apple/Unix
#        file.
# 
#        Other files can have their CREATOR and TYPE set from their
#        file name extension (the -map option), or their magic num-
#        ber  (the  -magic option). If the default match is used in
#        the mapping file, then these values override  the  default
#        CREATOR and TYPE.
# 
#        A   full	  CREATOR/TYPE	 database   can	  be   found   at
#        http://www.angelfire.com/il/szekely/index.html
# 
# MACINTOSH FILE FORMATS
#        Macintosh  files	 have  two  parts  called  the	Data  and
#        Resource	 fork.	Either may be empty. Unix (and many other
#        OSs) can only cope with files having one part  (or  fork).
#        To   add	 to  this,  Macintosh  files  have  a  number  of
#        attributes associated with them - probably the most impor-
#        tant  are  the TYPE and CREATOR. Again Unix has no concept
#        of these types of attributes.
# 
#        e.g. a Macintosh file may be a JPEG image where the  image
#        is  stored in the Data fork and a desktop thumbnail stored
#        in the Resource fork. It is usually the information in the
#        data fork that is useful across platforms.
# 
#        Therefore  to store a Macintosh file on a Unix filesystem,
#        a way has to be found to cope with the two forks	 and  the
#        extra  attributes  (which  are  referred	 to as the finder
#        info).  Unfortunately, it seems that every software  pack-
#        age  that stores Macintosh files on Unix has chosen a com-
#        pletely different storage method.
# 
#        The Apple/Unix formats that mkhybrid (partially)	 supports
#        are:
# 
#        CAP AUFS format
# 	      Data fork stored in a file. Resource fork in subdi-
# 	      rectory .resource with same filename as data  fork.
# 	      Finder  info  in .finderinfo subdirectory with same
# 	      filename.
# 
#        AppleDouble/Netatalk
# 	      Data fork stored in a file. Resource fork stored in
# 	      a	 file  with  same  name prefixed with "%". Finder
# 	      info also stored in same "%"  file.  Netatalk  uses
# 	      the  same	 format, but the resource fork/finderinfo
# 
# Version 1.12b5.1	   7 April 1999			       15
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
# 	      stored in subdirectory .AppleDouble with same  name
# 	      as data fork.
# 
#        AppleSingle
# 	      Data structures similar to above, except both forks
# 	      and finder info are stored in one file.
# 
#        Helios EtherShare
# 	      Data fork stored	in  a  file.  Resource	fork  and
# 	      finder  info  together  in  subdirectory .rsrc with
# 	      same filename as data fork.
# 
#        IPT UShare
# 	      Very similar to  the  EtherShare	format,	 but  the
# 	      finder info is stored slightly differently.
# 
#        MacBinary
# 	      Both forks and finder info stored in one file.
# 
#        Apple PC Exchange
# 	      Used  by	Macintoshes  to	 store Apple files on DOS
# 	      (FAT) disks.  Data fork stored in a file.	 Resource
# 	      fork     in     subdirectory    resource.frk    (or
# 	      RESOURCE.FRK). Finder info as one	 record	 in  file
# 	      finder.dat (or FINDER.DAT). Separate finder.dat for
# 	      each data fork directory.
# 
# 	      Note: normally files should  be  accessed	 directly
# 	      from  the	 DOS  media as mkhybrid needs to find out
# 	      the native FAT cluster size.   If	 the  native  FAT
# 	      cluster  size  is	 known,	 then  the  -cluster-size
# 	      option can be used to set the cluster size - useful
# 	      if  PC Exchange files have be copied from DOS disks
# 	      before running mkhybrid.	The cluster or allocation
# 	      size  can be found by using the DOS utility CHKDSK.
# 
# 	      May not work with PC Exchange v2.2 or higher  files
# 	      (available  with	MacOS 8.1).  DOS media containing
# 	      PC Exchange files should be mounted as  type  msdos
# 	      (not vfat) when using Linux.
# 
#        SGI/XINET
# 	      Used  by	SGI  machines  when they mount HFS disks.
# 	      Data fork stored in a file. Resource fork in subdi-
# 	      rectory  .HSResource with same name. Finder info as
# 	      one record in file .HSancillary. Separate .HSancil-
# 	      lary for each data fork directory.
# 
#        mkhybrid	 will  attempt to set the CREATOR, TYPE, date and
#        possibly other flags from the finder  info.  Additionally,
#        if  it  exists,	the  Macintosh	filename  is set from the
#        finder info, otherwise the Macintosh name is based on  the
#        Unix  filename  -  see  the  MACINTOSH  FILE NAMES section
#        below.
# 
# Version 1.12b5.1	   7 April 1999			       16
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        When using the -apple option, the  TYPE	and  CREATOR  are
#        stored  in  the	optional  System Use or SUSP field in the
#        ISO9660 Directory Record - in much the  same  way  as  the
#        Rock  Ridge attributes are. In fact to make life easy, the
#        Apple extensions are added at the beginning of the  exist-
#        ing  Rock  Ridge	 attributes (i.e. to get the Apple exten-
#        sions you get the Rock Ridge extensions as well).
# 
#        The Apple extensions  require  the  resource  fork  to  be
#        stored  as  an  ISO9660 associated file. This is just like
#        any normal file stored in the  ISO9660  filesystem  except
#        that  the  associated  file  flag  is set in the Directory
#        Record (bit 2). This file has the same name  as	the  data
#        fork  (the  file	 seen  by non-Apple machines). Associated
#        files are normally ignored by other OSs
# 
#        When using the -hfs option,  the	 TYPE  and  CREATOR  plus
#        other finder info, are stored in a separate HFS directory,
#        not visible on the ISO9660 volume. The HFS directory  ref-
#        erences	the  same  data and resource fork files described
#        above.
# 
#        In most cases, it is better to use the -hfs option instead
#        of  the	-apple	option, as the latter imposes the limited
#        ISO9660 characters  allowed  in	filenames.  However,  the
#        Apple  extensions do give the advantage that the files are
#        packed on the disk more efficiently and it may be possible
#        to  fit more files on a CD - important when the total size
#        of the source files is approaching 650MB.
# 
# MACINTOSH FILE NAMES
#        Where possible, the HFS filename that is	 stored	 with  an
#        Apple/Unix  file	 is used for the HFS part of the CD. How-
#        ever, not all the Apple/Unix encodings store the HFS file-
#        name  with  the finderinfo. In these cases, the Unix file-
#        name is used - with escaped  special  characters.  Special
#        characters include '/' and characters with codes over 127.
# 
#        Aufs escapes these characters by using ":" followed by the
#        character  code as two hex digits. Netatalk and EtherShare
#        have a similar scheme, but uses "%" instead of a ":".
# 
#        If mkhybrid can't find an HFS filename, then it	uses  the
#        Unix  name,  with any %xx or :xx characters (xx == two hex
#        digits) converted to a single character code. If "xx"  are
#        not  hex	 digits ([0-9a-fA-F]), then they are left alone -
#        although any remaining ":" is converted to "%" as colon is
#        the  HFS	 directory  separator.	Care must be taken, as an
#        ordinary Unix file with %xx or :xx will also be converted.
#        e.g.
# 
# Version 1.12b5.1	   7 April 1999			       17
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        This:2fFile   converted to This/File
# 
#        This:File     converted to This%File
# 
#        This:t7File   converted to This%t7File
# 
#        Although	 HFS  filenames appear to support upper and lower
#        case letters, the filesystem is case insensitive. i.e. the
#        filenames "aBc" and "AbC" are the same. If a file is found
#        in a directory with the same HFS name, then mkhybrid  will
#        attempt,	 where	possible, to make a unique name by adding
#        '_' characters to one of the filenames.
# 
#        If an HFS filename exists for a file,  then  mkhybrid  can
#        use  this  name	as  the	 starting  point for the ISO9660,
#        Joliet  and  Rock  Ridge	 filenames  using  the	-mac-name
#        option.	Normal	Unix files without an HFS name will still
#        use their Unix name.  e.g.
# 
#        If a MacBinary (or PC Exchange) file is stored as  someim-
#        age.gif.bin  on	the  Unix  filesystem, but contains a HFS
#        file called someimage.gif, then	this  is  the  name  that
#        would  appear on the HFS part of the CD. However, as mkhy-
#        brid uses the Unix name as  the	starting  point	 for  the
#        other names, then the ISO9660 name generated will probably
#        be SOMEIMAG.BIN and the Joliet/Rock Ridge would be someim-
#        age.gif.bin.  Although the actual data (in this case) is a
#        GIF image. This option will use the HFS	filename  as  the
#        starting	 point	and  the  ISO9660  name	 will probably be
#        SOMEIMAG.GIF and the Joliet/Rock Ridge  would  be  someim-
#        age.gif.
# 
#        Using  the  -mac-name  option will not currently work with
#        the -T option  -	 the  Unix  name  will	be  used  in  the
#        TRANS.TBL file, not the Macintosh name.
# 
#        The  existing  mkisofs  code  will  filter out any illegal
#        characters for the ISO9660 and Joliet  filenames,  but  as
#        mkisofs expects to be dealing directly with Unix names, it
#        leaves the Rock Ridge names as is.  But as '/' is a  legal
#        HFS  filename  character, the -mac-name option coverts '/'
#        to a '_' in a Rock Ridge filenames.
# 
#        If the Apple extensions are used, then  only  the  ISO9660
#        filenames  will	appear	on the Macintosh. However, as the
#        Macintosh ISO9660 drivers can use Level 2 filenames,  then
#        you  can use the -l option without problems on a Macintosh
#        -  still	 take  care   over   the   names,   for	  example
#        this.file.name  will  be	 converted to THIS.FILE i.e. only
#        have one '.', also  filename  abcdefgh  will  be	 seen  as
#        ABCDEFGH	 but  abcdefghi	 will be seen as ABCDEFGHI.  i.e.
#        with a '.' at the end - don't know if this is a	Macintosh
#        problem or mkisofs/mkhybrid problem. All filenames will be
#        in uppercase  when  viewed  on  a  Macintosh.  Of  course,
# 
# Version 1.12b5.1	   7 April 1999			       18
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        DOS/Win3.X  machines will not be able to see Level 2 file-
#        names...
# 
#        As Macintosh filenames do use the '~' and  '#'  characters
#        (especially  when using PC Exchange Macintosh files), then
#        the -a option should be given.
# 
# HFS BOOT DRIVER
#        It may be possible to make the hybrid  CD  bootable  on	a
#        Macintosh.
# 
#        A bootable HFS CD requires an Apple CD-ROM (or compatible)
#        driver, a bootable HFS partition and the necessary System,
#        Finder, etc. files.
# 
#        A driver can be obtained from any other Macintosh bootable
#        CD-ROM using the apple_driver utility. This file can  then
#        be used with the -boot-hfs-file option.
# 
#        The  HFS partition (i.e. the hybrid disk in our case) must
#        contain a suitable System Folder, again from  another  CD-
#        ROM or disk.
# 
#        For  a  partition  to  be bootable, it must have it's boot
#        block set. The boot block is in the first two blocks of	a
#        partition.  For a non-bootable partition the boot block is
#        full of zeros. Normally, when a System file is  copied  to
#        partition  on  a	 Macintosh disk, the boot block is filled
#        with a number of required settings - unfortunately I don't
#        know  the  full	spec  for the boot block, so I'm guessing
#        that the following will work OK.
# 
#        Therefore, the utility apple_driver also extracts the boot
#        block  from  the first HFS partition it finds on the given
#        CD-ROM and this is used for the HFS partition  created  by
#        mkhybrid.
# 
#        PLEASE NOTE
# 	      By  using	 a  driver  from  an Apple CD and copying
# 	      Apple software to your CD,  you  become  liable  to
# 	      obey  Apple  Computer, Inc. Software License Agree-
# 	      ments.
# 
# CONFIGURATION
#        mkhybrid looks for the .mkisofsrc file, first in the  cur-
#        rent working directory, then in the user's home directory,
#        and then in the directory in which the mkhybrid binary  is
#        stored.	This file is assumed to contain a series of lines
#        of the form "TAG=value", and in this way you  can  specify
#        certain	options.  The case of the tag is not significant.
#        Some fields in the volume header are not settable  on  the
# 
# Version 1.12b5.1	   7 April 1999			       19
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        command	line,  but  can be altered through this facility.
#        Comments may be placed in this  file,  using  lines  which
#        start with a hash (#) character.
# 
#        APPI   The  application	identifier  should  describe  the
# 	      application that will be on  the	disc.	There  is
# 	      space  on	 the  disc for 128 characters of informa-
# 	      tion.  May be overridden using the -A command  line
# 	      option.
# 
#        COPY   The copyright information, often the name of a file
# 	      on the disc containing the copyright notice.  There
# 	      is  space in the disc for 37 characters of informa-
# 	      tion.  May be overridden using the -copyright  com-
# 	      mand line option.
# 
#        ABST   The  abstract information, often the name of a file
# 	      on the disc containing an abstract.  There is space
# 	      in  the disc for 37 characters of information.  May
# 	      be overridden  using  the	 -abstract  command  line
# 	      option.
# 
#        BIBL   The  bibliographic information, often the name of a
# 	      file on the disc containing a bibliography.   There
# 	      is  space in the disc for 37 characters of informa-
# 	      tion.  May be overridden using the  -bilio  command
# 	      line option.
# 
#        PREP   This  should  describe  the  preparer of the CDROM,
# 	      usually with a mailing address  and  phone  number.
# 	      There  is	 space	on the disc for 128 characters of
# 	      information.  May be overridden using the	 -p  com-
# 	      mand line option.
# 
#        PUBL   This  should  describe  the publisher of the CDROM,
# 	      usually with a mailing address  and  phone  number.
# 	      There  is	 space	on the disc for 128 characters of
# 	      information.  May be overridden using the	 -P  com-
# 	      mand line option.
# 
#        SYSI   The  System Identifier.  There is space on the disc
# 	      for 32 characters of information.	 May be	 overrid-
# 	      den using the -sysid command line option.
# 
#        VOLI   The  Volume Identifier.  There is space on the disc
# 	      for 32 characters of information.	 May be	 overrid-
# 	      den using the -V command line option.
# 
#        VOLS   The  Volume  Set	Name.  There is space on the disc
# 	      for 278 characters of information.  May be overrid-
# 	      den using the -volset command line option.
# 
#        TYPE   The  default  TYPE  for  Macintosh  files.  Must be
# 	      exactly 4 characters.
# 
# Version 1.12b5.1	   7 April 1999			       20
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        CREATOR
# 	      The default CREATOR for Macintosh	 files.	 Must  be
# 	      exactly 4 characters.
# 
#        mkhybrid	 can  also  be	configured  at	compile time with
#        defaults	 for  many  of	these  fields.	 See   the   file
#        defaults.h.
# 
# AUTHOR
#        mkisofs is not based on the standard mk*fs tools for unix,
#        because we must generate a complete  copy of  an	 existing
#        filesystem on a disk in the  iso9660 filesystem.	 The name
#        mkisofs is probably a bit of a misnomer, since it not only
#        creates	the filesystem, but it also populates it as well.
# 
#        Eric	  Youngdale	  <ericy@gnu.ai.mit.edu>       or
#        <eric@andante.jic.com>  wrote  both  the	 Linux	isofs9660
#        filesystem and the mkisofs utility, and is currently main-
#        taining	them.	The  copyright for the mkisofs utility is
#        held by Yggdrasil Computing, Incorporated.
# 
#        mkhybrid is based on mkisofs and works in exactly the same
#        way as mkisofs without the HFS options. The change in name
#        is to signify that it does something extra. If you do  not
#        need  the  HFS  options,	 then  you should really be using
#        mkisofs.
# 
#        HFS hybrid code Copyright (C) James  Pearson  1997,  1998,
#        1999
#        libhfs code Copyright (C) 1996, 1997 Robert Leslie
#        libfile code Copyright (C) Ian F. Darwin 1986, 1987, 1989,
#        1990, 1991, 1992, 1994, 1995.
# 
# BUGS
#        Any files that have hard links to files not  in	the  tree
#        being copied to the iso9660 filesystem will have an incor-
#        rect file reference count.
# 
#        There may be some other ones.  Please, report them to  the
#        author.
# 
# HFS PROBLEMS/LIMITATIONS
#        I have had to make several assumptions on how I expect the
#        modified libhfs routines to work,  however  there  may  be
#        situations  that	 either	 I  haven't  thought  of, or come
#        across when these assumptions  fail.   Therefore	 I  can't
#        guarantee  that mkhybrid will work as expected (although I
#        haven't had a major problem yet). Most of the HFS features
#        work  fine,  however, some are not fully tested. These are
#        marked as Alpha above.
# 
# Version 1.12b5.1	   7 April 1999			       21
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        Output volume size must be at least 800Kb (libhfs limit	-
#        shouldn't really be a problem).
# 
#        Although	 HFS  filenames appear to support upper and lower
#        case letters, the filesystem is case insensitive. i.e. the
#        filenames "aBc" and "AbC" are the same. If a file is found
#        in a directory with the same HFS name, then mkhybrid  will
#        attempt,	 where	possible, to make a unique name by adding
#        '_' characters to one of the filenames.
# 
#        HFS file/directory names that share the first  31  charac-
#        ters  have  _N'	(N == decimal number) substituted for the
#        last few characters to generate unique names.
# 
#        Care must be taken when	"grafting"  Apple/Unix	files  or
#        directories   (see   above   for	 the  method  and  syntax
#        involved). It is not possible to use a  new  name  for  an
#        Apple/Unix  encoded  file/directory.  e.g. If a Apple/Unix
#        encoded file called "oldname" is to added to the CD,  then
#        you can not use the command line:
# 
# 	      mkhybrid -o output.raw -hfs newname=oldname cd_dir
# 
#        mkhybrid	 will be unable to decode "oldname". However, you
#        can graft Apple/Unix encoded files or directories as  long
#        as you do not atempt to give them new names as above.
# 
#        The -M option has no real meaning with an HFS volume - and
#        will probably not work.
# 
#        Symbolic links (as with all other non-regular  files)  are
#        not added to the HFS directory.
# 
#        Hybrid  volumes	may  be	 larger than pure ISO9660 volumes
#        containing the same data.
# 
#        The resulting hybrid volume can	be  accessed  on  a  Unix
#        machine	by  using  the	hfsutils  routines.  However,  no
#        changes should be made to the contents of  the  volume  as
#        it's not a "real" HFS volume.
# 
#        Using  the  -mac-name  option will not currently work with
#        the -T option  -	 the  Unix  name  will	be  used  in  the
#        TRANS.TBL file, not the Macintosh name.
# 
#        Although	 mkhybrid  does not alter the contents of a file,
#        if a binary file has it's TYPE set as 'TEXT',  it  may  be
#        read incorrectly on a Macintosh. Therefore a better choice
#        for the default TYPE may be '????'
# 
#        The -mac-boot-file option may not work at all...
# 
#        The -a option should be used at all  times.  It	may  well
#        become the default in future releases.
# 
# Version 1.12b5.1	   7 April 1999			       22
# 
# MKHYBRID(8)					      MKHYBRID(8)
# 
#        May not work with PC Exchange v2.2 or higher files (avail-
#        able with MacOS 8.1).  DOS media	 containing  PC	 Exchange
#        files  should  be  mounted  as  type msdos (not vfat) when
#        using Linux.
# 
# SEE ALSO
#        mkisofs(8), magic(5), apple_driver(8)
# 
# FUTURE IMPROVEMENTS
#        Some sort of gui interface.
# 
# AVAILABILITY
#        mkisofs	 is   available	  for	 anonymous    ftp    from
#        ftp://tsx-11.mit.edu/pub/linux/packages/mkisofs	and  many
#        other mirror sites.
# 
#        mkhybrid		  is		available	     from
#        ftp://ftp.ge.ucl.ac.uk/pub/mkhfs	   and	  hfsutils   from
#        ftp://ftp.mars.org/pub/hfs
# 
# Version 1.12b5.1	   7 April 1999			       23
# 
